% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_doseCurve.R
\name{drmMat}
\alias{drmMat}
\title{Fitting dose-response models for omics data matrix}
\usage{
drmMat(
  x,
  fitvar,
  fitvar.name = c("Dose", "Time", "Concentration")[1],
  curveid = NA,
  fct.name = c("LL.4()", "LL.3()", "LL.2()", "LL.5()")[1]
)
}
\arguments{
\item{x}{a numerical matrix where the rows are features and columns are samples.}

\item{fitvar}{a numerical variable has the same length as \code{ncol(x)} to 
indicate the dose/time/concentration conditions.}

\item{fitvar.name}{the name of the \code{fitvar}, a length one character. Will be used as the
label for x-axis when drawing the dose curve.}

\item{curveid}{a numeric vector or factor containing the grouping of the columns in x.}

\item{fct.name}{the function name, e.g. "LL.4()", "LL.3()", "LL.2()" and "LL.5()", 
which are defined in the \code{drc} package.}
}
\value{
a list of \code{drc} object
}
\description{
A convenient function to fit dose response models for every row in 
  an omics matrix using \code{drm} function in the \code{drc} package.
}
