% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxi_stats.R
\name{correlationAnalysis}
\alias{correlationAnalysis}
\title{Correlating a expression matrix with phenotypical variables}
\usage{
correlationAnalysis(x, pheno, min.value = 12, prefix = "Cor")
}
\arguments{
\item{x}{an expression matrix, rows are the features (e.g. proteins), 
columns are the samples}

\item{pheno}{a \code{data.frame} storing the numerical phenotypical variable to 
be correlated with the rows (features) in expression matrix.}

\item{min.value}{the minimum number of samples required in the correlation 
analysis, if lower than this number, NA will be returned.}

\item{prefix}{prefix of the names. Usually don't need to be changed by the user. 
When changes are needed, the prefix should be in a format like 
[analysis name]|[subset] so the "analysis name" and "subset" can be selected
in the \code{omicsViewer}.}
}
\value{
Every correlation analysis returns a \code{data.frame} with five 
  columns:
  \code{R} - pearson correlation coefficient
  \code{N} - number of values used in the analysis
  \code{P} - p-values returned by pearson correlation analysis
  \code{logP} - log transformed p-values
  \code{range} - the range of values in expression matrix used in the analysis
}
\description{
This is a convenience function to perform correlation analysis, 
  the output is in a format ready to be incorporated into object to be 
  visualized by \code{omicsViewer}.
}
\examples{
e1 <- matrix(rnorm(500), 50, 10)
rownames(e1) <- paste0("FT", 1:50)
p1 <- matrix(rnorm(50), 10, 5)
colnames(p1) <- paste0("PH", 1:5)
colnames(e1) <- rownames(p1) <- paste0("S", 1:10)
correlationAnalysis(x = e1, pheno = p1, min.value = 8)
}
