% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L0_module_app.R
\name{app_module}
\alias{app_module}
\title{Application level 0 module}
\usage{
app_module(
  input,
  output,
  session,
  .dir,
  filePattern = ".(RDS|db|sqlite|sqlite3)$",
  additionalTabs = NULL,
  ESVObj = reactive(NULL),
  esetLoader = readESVObj,
  exprsGetter = getExprs,
  pDataGetter = getPData,
  fDataGetter = getFData,
  imputeGetter = getExprsImpute,
  defaultAxisGetter = getAx,
  appName = "omicsViewer",
  appVersion = packageVersion("omicsViewer")
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{.dir}{reactive; directory containing the .RDS file of \code{ExpressionSet} or \code{SummarizedExperiment}}

\item{filePattern}{file pattern to be displayed.}

\item{additionalTabs}{additional tabs added to "Analyst" panel}

\item{ESVObj}{the ESV object
given, the drop down list should be disable in the "ui" component.}

\item{esetLoader}{function to load the eset object, if an RDS file, should be "readRDS"}

\item{exprsGetter}{function to get the expression matrix from eset}

\item{pDataGetter}{function to get the phenotype data from eset}

\item{fDataGetter}{function to get the feature data from eset}

\item{imputeGetter}{function to get the imputed expression matrix from eset, only used when exporting imputed data to excel}

\item{defaultAxisGetter}{function to get the default axes to be visualized. It should be a function with two 
arguments: x - the object loaded to the viewer; what - one of "sx", "sy", "fx" and "fy", representing the 
sample space x-axis, sample space y-axis, feature space x-axis and feature space y-axis respectively.}

\item{appName}{name of the application}

\item{appVersion}{version of the application}
}
\value{
do not return any values
}
\description{
Function should only be used for the developers
}
\examples{
if (interactive()) {
  dir <- system.file("extdata", package = "omicsViewer")
  server <- function(input, output, session) {
    callModule(app_module, id = "app", dir = reactive(dir))
  }
  ui <- fluidPage(
    app_ui("app")
  )
  shinyApp(ui = ui, server = server)
}
}
