% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-utils.R
\name{makeExampleMatchedDataSet}
\alias{makeExampleMatchedDataSet}
\alias{makeExampleMatchedDataSet,character_OR_missing,logical_OR_missing,character_OR_missing,logical_OR_missing-method}
\title{Function for generating an example matchRanges or Matched dataset}
\usage{
makeExampleMatchedDataSet(
  type = "DataFrame",
  matched = FALSE,
  method = "rejection",
  replace = FALSE,
  ...
)

\S4method{makeExampleMatchedDataSet}{character_OR_missing,logical_OR_missing,character_OR_missing,logical_OR_missing}(type, matched, method, replace)
}
\arguments{
\item{type}{Character designating which type of dataset to make.
options are one of 'data.frame', 'data.table', 'DataFrame',
'GRanges', or 'GInteractions'.}

\item{matched}{TRUE/FALSE designating whether to generate a
Matched dataset (\code{matched = TRUE}) or an input dataset
for \code{matchRanges()} (\code{matched = FALSE}).}

\item{method}{Character describing which matching method to use.
Supported options are either 'nearest', 'rejection', or 'stratified'.}

\item{replace}{TRUE/FALSE describing whether to select matches with
or without replacement.}

\item{...}{Additional arguments}
}
\value{
Returns an example Matched dataset or an example dataset for
input to \code{matchRanges()}.
}
\description{
This function will generate an example dataset as either 1) input
for \code{matchRanges()} (when \code{matched = FALSE}) or 2) a
Matched Object (when \code{matched = TRUE}).
}
\details{
When \code{matched = FALSE}, the data returned contains 3 different
features that can be subset to perform matching.
}
\examples{
## Make examples for matchRanges() (i.e matched = FALSE)
set.seed(123)
makeExampleMatchedDataSet()
head(makeExampleMatchedDataSet(type = 'data.frame', matched = FALSE))
makeExampleMatchedDataSet(type = 'data.table', matched = FALSE)
makeExampleMatchedDataSet(type = 'DataFrame', matched = FALSE)
makeExampleMatchedDataSet(type = 'GRanges', matched = FALSE)
makeExampleMatchedDataSet(type = 'GInteractions', matched = FALSE)

## Make Matched class examples (i.e. matched = TRUE)
set.seed(123)
makeExampleMatchedDataSet(matched = TRUE)
makeExampleMatchedDataSet(type = 'DataFrame', matched = TRUE,
                          method = 'rejection',
                          replace = FALSE)
makeExampleMatchedDataSet(type = 'GRanges', matched = TRUE,
                          method = 'rejection',
                          replace = FALSE)
# throwing error (April 2023)
#makeExampleMatchedDataSet(type = 'GInteractions', matched = TRUE,
#                          method = 'rejection',
#                          replace = FALSE)

}
