% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleoSimFunctions.R
\name{plot.syntheticNucReads}
\alias{plot.syntheticNucReads}
\title{Generate a graph of a synthetic nucleosome map containing forward and
reverse reads}
\usage{
\method{plot}{syntheticNucReads}(x, ...)
}
\arguments{
\item{x}{a list marked as a \code{syntheticNucReads} class}

\item{...}{\code{...} extra arguments passed to the \code{plot} function}
}
\value{
a graph of a synthetic nucleosome map containing forward and
reverse reads
}
\description{
Generate a graph for
a list marked as an \code{syntheticNucReads} class
}
\examples{

## Generate a synthetic map with 20 well-positioned nucleosomes, 5 fuzzy
## nucleosomes and 10 deleted nucleosomes using a Student distribution
## with a variance of 10 for the well-positioned nucleosomes,
## a variance of 20 for the fuzzy nucleosomes and a seed of 15
syntheticNucSample <- syntheticNucReadsFromDist(wp.num = 30, wp.del = 10,
wp.var = 10, fuz.num = 5, fuz.var = 20, rnd.seed = 15,
distr = "Student", offset = 1000)

## Create graph using the synthetic map
plot(syntheticNucSample, xlab="Position", ylab="Coverage")

}
\author{
Astrid Deschenes, Rawane Samb
}
