% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{init_log}
\alias{init_log}
\title{Initialize log to a file}
\usage{
init_log(log_file)
}
\arguments{
\item{log_file}{Path to the log file}
}
\value{
None, the function is invoked for its side effect.
}
\description{
Initialize a log file with the current data and time.
All major operations run after this will be logged to the specified file.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
file_name <- "log.txt"
init_log(file_name)
# Print the contents of the file
scan(file_name, sep = "\n", what = "character")
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link{log_text}}, \code{\link{finish_log}}
}
