% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructor.R
\name{import_from_msdial}
\alias{import_from_msdial}
\title{Import data from a TSV file created by MS-DIAL}
\usage{
import_from_msdial(
  file,
  id_column = NULL,
  id_prefix = "ID_",
  split_by = NULL,
  name = NULL,
  mz_limits = c(10, 2000),
  rt_limits = c(0, 20),
  skip_checks = FALSE
)
}
\arguments{
\item{file}{path to the TSV file}

\item{id_column}{character, column name for unique identification of samples}

\item{id_prefix}{character, prefix for autogenerated sample IDs}

\item{split_by}{character vector, in the case where all the modes are in the 
same Excel file, the column names of feature data used to separate the modes 
(usually Mode and Column)}

\item{name}{in the case where the Excel file only contains one mode, the 
name of the mode, such as "Hilic_neg"}

\item{mz_limits}{numeric vector of two, all m/z values should be in between 
these}

\item{rt_limits}{numeric vector of two, all retention time values should be 
in between these}

\item{skip_checks}{logical: skip checking and fixing of data integrity. Not 
recommended, but sometimes useful when you just want to read the data in as 
is and fix errors later. The data integrity checks are important for 
functioning of notame.}
}
\value{
A SummarizedExperiment with assays, rowData and colData filled from
the TSV file.
}
\description{
Reads a tab-delimited peak table (TSV) exported from MS-DIAL. This works 
similarly to \code{\link{import_from_excel}}, but removes the need to 
manually open and re-save the TSV files in Excel. Excludes any summary
statistics computed by MS-DIAL, such as average abundances, since these are
not valid after notame processing.
}
\examples{
\donttest{
# Read a TSV peak table
# data <- import_from_msdial(file = "path/to/peak_table.tsv", name = "RP_neg")
}

}
