% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructor.R
\name{import_from_excel}
\alias{import_from_excel}
\title{Read formatted Excel files}
\usage{
import_from_excel(
  file,
  sheet = 1,
  id_column = NULL,
  corner_row = NULL,
  corner_column = NULL,
  id_prefix = "ID_",
  split_by = NULL,
  name = NULL,
  mz_limits = c(10, 2000),
  rt_limits = c(0, 20),
  skip_checks = FALSE
)
}
\arguments{
\item{file}{path to the Excel file}

\item{sheet}{the sheet number or name}

\item{id_column}{character, column name for unique identification of samples}

\item{corner_row}{integer, the bottom row of sample information,
usually contains data file names and feature info column names.
If set to NULL, will be detected automatically.}

\item{corner_column}{integer or character, the corresponding column number 
or the column name (letter) in Excel.
If set to NULL, will be detected automatically.}

\item{id_prefix}{character, prefix for autogenerated sample IDs}

\item{split_by}{character vector, in the case where all the modes are in the 
same Excel file, the column names of feature data used to separate the modes 
(usually Mode and Column)}

\item{name}{in the case where the Excel file only contains one mode, the 
name of the mode, such as "Hilic_neg"}

\item{mz_limits}{numeric vector of two, all m/z values should be in between 
these}

\item{rt_limits}{numeric vector of two, all retention time values should be 
in between these}

\item{skip_checks}{logical: skip checking and fixing of data integrity. Not 
recommended, but sometimes useful when you just want to read the data in as 
is and fix errors later. The data integrity checks are important for 
functioning of notame.}
}
\value{
A SummarizedExperiment with assays, rowData and colData filled from
the Excel file.
}
\description{
Reads data from an Excel file of the following format:
\itemize{
  \item Left side of the sheet contains information about the features, size 
features x feature info columns
  \item Top part contains sample information, size sample info variables x 
samples
  \item The middle contains the actual abundances, size features x samples
}
Exported data from MS-DIAL converted to an excel file creates such format.
}
\examples{
data <- import_from_excel(
  file = system.file("extdata", "toy_notame_set.xlsx", 
  package = "notame"), sheet = 1, corner_row = 11, corner_column = "H",
  split_by = c("Column", "Ion_mode"))

}
