% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_correction.R
\name{pca_bhattacharyya_dist}
\alias{pca_bhattacharyya_dist}
\title{Bhattacharyya distance between batches in PCA space}
\usage{
pca_bhattacharyya_dist(
  object,
  batch,
  all_features = FALSE,
  center = TRUE,
  scale = "uv",
  nPcs = 3,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{batch}{column name of pheno data giving the batch labels}

\item{all_features}{logical, should all features be used? If FALSE
(the default), flagged features are removed before imputation.}

\item{center}{logical, should the data be centered prior to PCA?
(usually yes)}

\item{scale}{scaling used, as in 
\code{\link[pcaMethods]{prep}}. Default is "uv" for unit variance}

\item{nPcs}{the number of principal components to use}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other parameters to \code{\link[pcaMethods]{pca}}}
}
\value{
A matrix of Bhattacharyya distances between batches.
}
\description{
Computes Bhattacharyya distance between all pairs of batches using 
\code{\link[fpc:bhattacharyya.matrix]{fpc:bhattacharyya.matrix}} 
after projecting the samples into PCA space with 
\code{\link[pcaMethods]{pca}}.
}
\examples{
data(toy_notame_set)
# Batch correction
replicates <- list(which(toy_notame_set$QC == "QC"))
batch_corrected <- ruvs_qc(toy_notame_set, replicates = replicates)
# Evaluate batch correction
pca_bhattacharyya_dist(toy_notame_set, batch = "Batch")
pca_bhattacharyya_dist(batch_corrected, batch = "Batch")

}
