% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{impute_simple}
\alias{impute_simple}
\title{Simple imputation}
\usage{
impute_simple(object, value, na_limit = 0, assay.type = NULL, name = NULL)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{value}{the value used for imputation, either a numeric or one of 
'"min", "half_min", "small_random", see above}

\item{na_limit}{only impute features with the proportion of NAs over this 
limit. For example, if \code{na_limit = 0.5}, only features with at least 
half of the values missing are imputed.}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{name}{character, name of the resultant assay in case of multiple assays}
}
\value{
A SummarizedExperiment object with imputed peak table.
}
\description{
Impute missing values using a simple imputation strategy. All missing values
of a feature are imputed with the same value. It is possible
to only impute features with a large number of missing values this way. This 
can be useful for using this function before random forest imputation to 
speed things up.
The imputation strategies available are:
\itemize{
\item a numeric value: impute all missing values in all features with the 
same value, e.g. 1
\item "mean": impute missing values of a feature with the mean of observed 
values of that feature
\item "median": impute missing values of a feature with the median of 
observed values of that feature
\item "min": impute missing values of a feature with the minimum observed 
value of that feature
\item "half_min": impute missing values of a feature with half the minimum 
observed value of that feature
\item "small_random": impute missing values of a feature with random numbers 
between 0 and the
minimum of that feature (uniform distribution, remember to set the seed 
number!).
}
}
\examples{
data(toy_notame_set)
missing <- mark_nas(toy_notame_set, 0)
imputed <- impute_simple(missing, value = "min")

}
