% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{plot_p_histogram}
\alias{plot_p_histogram}
\title{Histogram of p-values}
\usage{
plot_p_histogram(p_values, hline = TRUE, combine = TRUE, x_label = "p-value")
}
\arguments{
\item{p_values}{list or data frame, each element/column is a vector of p-
values. The list names are used as plot titles}

\item{hline}{logical, whether a horizontal line representing uniform 
distribution should be plotted}

\item{combine}{logical, whether plots of individual p-value vectors should 
be combined into a single object.
Set to FALSE if you want to add other plots to the list before plotting}

\item{x_label}{the x-axis label}
}
\value{
If combine = TRUE, a ggplot object. Otherwise a list of ggplot 
objects.
}
\description{
Draws histograms of p-values with expected uniform distribution represented 
by a dashed red line.
}
\examples{
data(toy_notame_set, package = "notame")
lm_sample <- notameStats::perform_lm(notame::drop_qcs(toy_notame_set),
  "Feature ~ Injection_order")
p_values <- list("Biological samples" = lm_sample$Injection_order.p.value)
plot_p_histogram(p_values)

}
