% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_plots.R
\name{plot_dendrogram}
\alias{plot_dendrogram}
\title{Sample dendrogram}
\usage{
plot_dendrogram(
  object,
  all_features = FALSE,
  color,
  dist_method = "euclidean",
  clust_method = "ward.D2",
  center = TRUE,
  scale = "uv",
  title = "Dendrogram of hierarchical clustering",
  subtitle = NULL,
  color_scale = getOption("notame.color_scale_dis"),
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{color}{character, name of the column used for coloring the sample 
labels}

\item{dist_method}{distance method used in clustering as in
\code{\link[stats]{dist}}}

\item{clust_method}{method used in clustering as in
\code{\link[stats]{hclust}}}

\item{center}{logical, should the data be centered?}

\item{scale}{scaling used, as in 
\code{\link[pcaMethods]{prep}}. Default is "uv" for unit variance}

\item{title}{The plot title}

\item{subtitle}{The plot subtitle}

\item{color_scale}{the color scale as returned by a ggplot function.}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A ggplot object.
}
\description{
Draws a dendrogram of a hierarchical clustering applied to the samples of an 
experiment.
}
\examples{
data(toy_notame_set, package = "notame")
plot_dendrogram(toy_notame_set, color = "Group")

}
\seealso{
\code{\link{dist}} \code{\link{hclust}}
}
