% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Volcano plot}
\usage{
volcano_plot(
  object,
  x,
  p,
  p_fdr = NULL,
  color = NULL,
  p_breaks = c(0.05, 0.01, 0.001, 1e-04),
  fdr_limit = 0.05,
  log2_x = FALSE,
  center_x_axis = TRUE,
  x_lim = NULL,
  label = NULL,
  label_limit = 0.05,
  color_scale = getOption("notame.color_scale_con"),
  title = "Volcano plot",
  subtitle = NULL,
  text_base_size = 14,
  label_text_size = 4,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object or a data frame.
Feature data is used. If x is a data frame, it is used as is.}

\item{x, p}{the column names of effect size (x-axis) and p-values}

\item{p_fdr}{column name of FDR corrected p-values, used to draw a line 
showing the fdr-corrected significance level}

\item{color}{column name used to color the plots}

\item{p_breaks}{a numerical vector of the p_values to show on the y-axis}

\item{fdr_limit}{the significance level used in the experiment}

\item{log2_x}{logical, whether effect size should be plotted on a log2 axis.}

\item{center_x_axis}{logical, whether x-axis should be centered. If 
\code{TRUE}, the "zero-effect" will be on the middle of the plot. The 
"zero effect" is 0 if \code{log2_x = FALSE} and 1 if \code{log2_x = TRUE}}

\item{x_lim}{numerical vector of length 2 for manually setting the x-axis 
limits}

\item{label}{column name used to label the plots}

\item{label_limit}{numeric, p-value which is used to limit label plotting. 
Defaults to 0.05.}

\item{color_scale}{the color scale as returned by a ggplot function}

\item{title, subtitle}{the title and subtitle of the plot}

\item{text_base_size}{integer, base size for text in figures}

\item{label_text_size}{numeric, size of the labels}

\item{...}{parameters passed to \code{\link[ggplot2]{geom_point}},
such as shape and alpha values. New aesthetics can
also be passed using \code{mapping = aes(...)}.}
}
\value{
A ggplot object.
}
\description{
Draws a volcano plot of effect size and p-values.
}
\examples{
data(toy_notame_set, package = "notame")
# naturally, this looks messy as there are not enough p-values
lm_results <- notameStats::perform_lm(notame::drop_qcs(toy_notame_set), 
  formula_char = "Feature ~ Group")
volcano_plot(lm_results,
  x = "GroupB.estimate",
  p = "GroupB.p.value", p_fdr = "GroupB.p.value_FDR",
  label = "Feature_ID",
  fdr_limit = 0.1
)

}
