% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_plots.R
\name{save_group_boxplots}
\alias{save_group_boxplots}
\title{Save box plots of each feature by group}
\usage{
save_group_boxplots(
  object,
  all_features = FALSE,
  save = TRUE,
  file_path = NULL,
  format = "emf",
  x,
  color,
  title = "Feature_ID",
  subtitle = NULL,
  color_scale = getOption("notame.color_scale_dis"),
  text_base_size = 14,
  box_width = 0.8,
  line_width = 0.5,
  point_size = 3,
  title_line_length = 40,
  theme = theme_bw(base_size = text_base_size),
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? 
If FALSE (the default), flagged features are removed before visualization.}

\item{save}{logical, if false, the plots are not saved but returned as a list}

\item{file_path}{character, a file path for PDF or prefix added to the file 
paths for other formats}

\item{format}{character, format in which the plots should be saved}

\item{x}{character, name of the column to be used as x-axis}

\item{color}{character, name of the column to be used for coloring}

\item{title, subtitle}{column names from feature data to use as plot 
title/filename and subtitle.
Set to NULL for no title/subtitle, this creates running numbered filenames}

\item{color_scale}{the color scale as returned by a ggplot function}

\item{text_base_size}{integer, base size for text in figures}

\item{box_width}{numeric, width of the boxes}

\item{line_width}{numeric, width of the lines}

\item{point_size}{numeric, size of the mean points}

\item{title_line_length}{integer, maximum length of the title line in 
characters, passed to \code{\link[stringr]{str_wrap}}}

\item{theme}{a ggplot theme to be added to the plot}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other arguments to graphic device functions, like width and height}
}
\value{
By default, the function is invoked for its plot-saving side effect. 
The function returns a list of plots when \code{save = FALSE}.
}
\description{
Draws a boxplot of feature abundances in each group.
A separate plot is drawn and saved for each feature.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(toy_notame_set, package = "notame")
# Default boxplots by group
save_group_boxplots(notame::drop_qcs(toy_notame_set)[1:10],
  file_path = "./group_boxplots.pdf",
  format = "pdf", x = "Group", color = "Group"
)
# x and color can be a different variable
save_group_boxplots(notame::drop_qcs(toy_notame_set)[1:10],
  file_path = "./time_boxplots/",
  format = "emf",
  x = "Time",
  color = "Group"
)
# Plot one feature
save_group_boxplots(notame::drop_qcs(toy_notame_set)[1, ], save = FALSE, 
  x = "Group", color = "Group")
\dontshow{setwd(.old_wd)}

}
\seealso{
\code{\link{save_plot}}
}
