% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_non_parametric}
\alias{perform_non_parametric}
\title{Pairwise and paired non-parametric tests}
\usage{
perform_non_parametric(
  object,
  formula_char,
  is_paired = FALSE,
  id = NULL,
  all_features = FALSE,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{formula_char}{character, the formula to be used in the tests}

\item{is_paired}{logical, use paired test}

\item{id}{character, name of the subject identification column for paired 
version}

\item{all_features}{should all features be included in FDR correction?}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other parameters passed to test \code{\link{wilcox.test}}}
}
\value{
A data frame with the results.
}
\description{
Performs pairwise and paired non-parametric tests. The default is Mann-
Whitney U test, use \code{is_paired} for Wilcoxon signed rank tests.
}
\details{
P-values of each comparison are corrected separately from each 
other. The model is fit on combined_data(object). Thus, column names
in pheno data can be specified. To make the formulas flexible, the word 
"Feature" must be used to signal the role of the features in the formula. 
"Feature" will be replaced by the actual features during model fitting. 
For example, if testing for equality of means in study groups, use 
"Feature ~ Group".
}
\examples{
data(toy_notame_set, package = "notame")
# Including QCs as a study group for example for pairwise tests
mann_whitney_results <- perform_non_parametric(toy_notame_set, 
  formula_char = "Feature ~ Group")
# Using paired mode (pairs with QC are skipped as there are no common IDs in 
# 'toy_notame_set')
wilcoxon_signed_results <- perform_non_parametric(toy_notame_set,
  formula_char = "Feature ~ Time",
  is_paired = TRUE,
  id = "Subject_ID")
# Only two groups
mw_results <-perform_non_parametric(notame::drop_qcs(toy_notame_set), 
  formula_char = "Feature ~ Group")

}
\seealso{
\code{\link[stats]{wilcox.test}}
}
