% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{summarize_results}
\alias{summarize_results}
\title{Statistics cleaning}
\usage{
summarize_results(
  df,
  remove = c("Intercept", "CI95", "Std_error", "t_value", "z_value", "R2"),
  rename = NULL,
  summary = TRUE,
  p_limit = 0.05,
  fdr = TRUE
)
}
\arguments{
\item{df}{data frame, statistics results}

\item{remove}{list, should contain strings that are matching to unwanted 
columns}

\item{rename}{named list, names should contain matches that are replaced 
with values}

\item{summary}{logical, should summary columns be added}

\item{p_limit}{numeric, limit for p-values to be counted}

\item{fdr}{logical, should summary be done with fdr-fixed values}
}
\value{
A data frame with removed and/or renamed columns.
}
\description{
Uses regexp to remove unnecessary columns from statistics results data frame.
Can also rename columns effectively.
}
\examples{
data(toy_notame_set, package = "notame")
# Simple manipulation to linear model results
lm_results <- perform_lm(notame::drop_qcs(toy_notame_set), 
  formula_char = "Feature ~ Group + Time")
lm_results <- summarize_results(lm_results,
  rename = c("GroupB" = "GroupB_vs_A", "Time2" = "Time2_vs_1")
)

}
