% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{pls}
\alias{pls}
\alias{mixomics_pls}
\alias{mixomics_pls_optimize}
\alias{mixomics_spls_optimize}
\title{PLS}
\usage{
mixomics_pls(
  object,
  y,
  ncomp,
  all_features = FALSE,
  covariates = NULL,
  assay.type = NULL,
  ...
)

mixomics_pls_optimize(
  object,
  y,
  ncomp,
  plot_perf = FALSE,
  folds = 5,
  nrepeat = 50,
  all_features = FALSE,
  covariates = NULL,
  assay.type = NULL,
  ...
)

mixomics_spls_optimize(
  object,
  y,
  ncomp,
  plot_perf = FALSE,
  n_features = c(seq_len(10), seq(20, 300, 10)),
  folds = 5,
  nrepeat = 50,
  all_features = FALSE,
  covariates = NULL,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{y}{character vector, column names of the grouping variable to predict}

\item{ncomp}{number of X components}

\item{all_features}{logical, should all features be included in the model? 
if FALSE, flagged features are left out}

\item{covariates}{character, column names of pheno datato use as covariates 
in the model, in addition to molecular features}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{any parameters passed to 
\code{\link[mixOmics]{pls}} or \code{\link[mixOmics]{spls}}}

\item{plot_perf}{plot performance of models in cross-validation}

\item{folds}{the number of folds to use in k-fold cross validation}

\item{nrepeat}{the number of times to repeat the cross validation. Lower 
this for faster testing.}

\item{n_features}{the number of features to try for each component}
}
\value{
An object of class "mixo_pls" or "mixo_spls". For the optimized and 
sparse models, a list with object of class "mixo_plsda" and a performance 
plot.
}
\description{
Simple wrappers for fitting a PLS model using mixOmics package. The result 
can then be passed to many of the mixOmics functions for prediction, 
performance evaluation etc.
}
\details{
\itemize{
\item{\code{mixomics_pls} A simple PLS model with set number of components 
and all features}
\item{\code{mixomics_pls_optimize} Test different numbers of components}
\item{\code{mixomics_spls_optimize} sPLS model: Test different numbers of 
components and features}
}
}
\examples{
data(toy_notame_set, package = "notame")
pls_res <- mixomics_pls(toy_notame_set, y = "Injection_order", ncomp = 3)
# Cross-validation repeated only 5 times for quick run time 
pls_opt <- mixomics_pls_optimize(toy_notame_set, 
  y = "Injection_order", ncomp = 3, nrepeat = 5)
spls_opt <- mixomics_spls_optimize(toy_notame_set,
  y = "Injection_order", ncomp = 3,
  n_features = c(1:10, 12, 15, 20), nrepeat = 5
)
# Plot score plot of any final model
mixOmics::plotIndiv(pls_res,  
  comp = seq_len(2), group = toy_notame_set$Group, 
  ind.names = FALSE, title = "PLS scores plot", legend = TRUE)

# Proportion of variance explained
pls_res$prop_expl_var$X[seq_len(2)] |> round(digits = 3) * 100

}
\seealso{
\code{\link[mixOmics]{pls}}, \code{\link[mixOmics]{perf}},
\code{\link[mixOmics]{spls}}, \code{\link[mixOmics]{tune.spls}}
}
