% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmb_accessors.R
\name{nmb_get_gs}
\alias{nmb_get_gs}
\title{Accessor function for global scores}
\usage{
nmb_get_gs(nmb_object)
}
\arguments{
\item{nmb_object}{A `NipalsResult` object.}
}
\value{
a matrix containing global scores.
}
\description{
Retrieves the global scores as a matrix from a `NipalsResult`
object, typically output from `nipals_multiblock()`.
}
\examples{
data("NCI60")
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                               colData=metadata_NCI60)
mcia_out <- nipals_multiblock(data_blocks_mae, num_PCs = 10)
global_scores <- nmb_get_gs(mcia_out)
}
