% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmb_accessors.R
\name{nmb_get_eigs}
\alias{nmb_get_eigs}
\title{Accessor function for eigenvalues}
\usage{
nmb_get_eigs(nmb_object)
}
\arguments{
\item{nmb_object}{A `NipalsResult` object.}
}
\value{
a matrix containing the eigenvalues for all global scores.
}
\description{
Retrieves the eigenvalues
from a `NipalsResult` object, typically output from `nipals_multiblock()`.
}
\examples{
data("NCI60")
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_out <- nipals_multiblock(data_blocks_mae, num_PCs = 10)
nipals_eigvals <- nmb_get_eigs(mcia_out)
}
