% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet.R
\name{screen_cv.glasso}
\alias{screen_cv.glasso}
\title{Cross-validated glasso with additional thresholding}
\usage{
screen_cv.glasso(x, include.mean = FALSE, folds = min(10, dim(x)[1]),
  length.lambda = 20, lambdamin.ratio = ifelse(ncol(x) > nrow(x), 0.01,
  0.001), penalize.diagonal = FALSE, trunc.method = "linear.growth",
  trunc.k = 5, plot.it = FALSE, se = FALSE, use.package = "huge",
  verbose = FALSE)
}
\arguments{
\item{x}{The input data. Needs to be a num.samples by dim.samples matrix.}

\item{include.mean}{Include mean in likelihood. TRUE / FALSE (default).}

\item{folds}{Number of folds in the cross-validation (default=10).}

\item{length.lambda}{Length of lambda path to consider (default=20).}

\item{lambdamin.ratio}{Ratio lambda.min/lambda.max.}

\item{penalize.diagonal}{If TRUE apply penalization to diagonal of inverse
covariance as well. (default=FALSE)}

\item{trunc.method}{None / linear.growth (default) / sqrt.growth}

\item{trunc.k}{truncation constant, number of samples per predictor (default=5)}

\item{plot.it}{TRUE / FALSE (default)}

\item{se}{default=FALSE.}

\item{use.package}{'glasso' or 'huge' (default).}

\item{verbose}{If TRUE, output la.min, la.max and la.opt (default=FALSE).}
}
\value{
Returns a list with named elements 'rho.opt', 'w', 'wi', 'wi.orig', 
         'mu'. Variable rho.opt is the optimal (scaled) penalization 
         parameter (rho.opt=2*la.opt/n). Variable w is the estimated 
         covariance matrix. The variables wi and wi.orig are 
         matrices of size dim.samples by dim.samples containing the 
         truncated and untruncated inverse covariance matrix. Variable 
         mu is the mean of the input data.
}
\description{
Cross-validated glasso with additional thresholding
}
\details{
Run glasso on a single dataset, using cross-validation to estimate the
penalty parameter lambda. Performs additional thresholding (optionally).
}
\examples{
n=50
p=5
x=matrix(rnorm(n*p),n,p)
wihat=screen_cv.glasso(x,folds=2)$wi
}
\author{
n.stadler
}
