% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netsim.R
\name{generate_inv_cov}
\alias{generate_inv_cov}
\title{generate_inv_cov}
\usage{
generate_inv_cov(p = 162, sparsity = 0.7)
}
\arguments{
\item{p}{Dimensionality of the matrix.}

\item{sparsity}{Determined the proportion of non-zero off-diagonal entries.}
}
\value{
A p by p positive definite inverse covariance matrix.
}
\description{
Generate an inverse covariance matrix with a given sparsity and 
dimensionality
}
\details{
This function generates an inverse covariance matrix, with at most 
(1-sparsity)*p(p-1)
non-zero off-diagonal entries, where the non-zero entries are sampled from a 
beta distribution.
}
\examples{
generate_inv_cov(p=162)
}
