% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runStereogene.R
\name{runStereogene}
\alias{runStereogene}
\title{runStereogene}
\usage{
runStereogene(track_files,
        name_config,
        pcorProfile = NULL,
        confounder = NULL,
        nShuffle = 1000,
        get_error = FALSE)
}
\arguments{
\item{track_files}{Vector of at least two track or interval file names to be
pairwise-correlated by StereoGene. Required.}

\item{name_config}{Name of corresponding configuration file; a string.
Required}

\item{pcorProfile}{Name of track file name for partial correlation; a string.
More information for this can be found in the StereoGene README. Optional}

\item{confounder}{Confounder file name; a string. More information for this
can be found in the StereoGene README. Optional}

\item{nShuffle}{Permutations used to estimate error. Default 5000.}

\item{get_error}{Whether to calculate the standard error of background
permutations from nShuffle. FALSE will save calculation time. Default FALSE}
}
\value{
generates StereoGene output files in directory
}
\description{
Writes a StereoGene script in the working directory
}
\examples{
runStereogene(track_files = c("chr4and5_3UTR_stem_liftOver.bedGraph",
                             "chr4and5_liftOver.bedGraph"),
             name_config = "chr4and5_3UTR.cfg")

}
