% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_show_group}
\alias{ndex_user_show_group}
\title{Get User's Membership in Group}
\usage{
ndex_user_show_group(ndexcon, userId, groupId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID (UUID) of the user}

\item{groupId}{character; unique ID (UUID) of the group}
}
\value{
List of permissions of that user or empty object
}
\description{
Returns the permission that the user specified in the URL has on the given group. Returns an empty object if the authenticated user is not a member of this group.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$group$get
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get its id
# user = ndex_find_user_byName(ndexcon, 'SomeUserName')
# userId = user$externalId
## Find the user's groups and get one group id
# groups = ndex_user_list_groups(ndexcon, userId)
# groupId = groups[1,"externalId"]
## get users's permission in the group
# userPermissions = ndex_user_show_group(ndexcon, userId, groupId)
## $`uuuuuuuu-ssss-eeee-rrrr-123456789abc`
## [1] "MEMBER"
NULL
}
