% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_list_permissions}
\alias{ndex_user_list_permissions}
\title{Get User's Network Permissions}
\usage{
ndex_user_list_permissions(
  ndexcon,
  userId,
  type = NULL,
  directonly = FALSE,
  start = NULL,
  size = NULL
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID (UUID) of the user}

\item{type}{character (optional)("READ"|"WRITE"|"ADMIN"); constrains the type of the returned permission. If not set (or NULL), all permission types will be returned.}

\item{directonly}{logical (default: FALSE); If directonly is set to true, permissions granted through groups are not included in the result}

\item{start}{integer (optional); specifies that the result is the nth page of the requested data.}

\item{size}{integer (optional); specifies the number of data items in each page.}
}
\value{
List of highest permissions of that user or empty object
}
\description{
This function returns networks for which the authenticated user is assigned the specified permission. Userid is the UUID of the authenticated user. Returns a JSON map in which the keys are network UUIDs and values are the highest permission assigned to the authenticated user.#'
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$permission$list
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## get user by name to get UUID
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## get all network permissions of the user
# networkPermissions = ndex_user_list_permissions(ndexcon, userId)
## $`nnneeett-wwww-oooo-rrrr-kkkkkkk11111`
## [1] "ADMIN"
## $`nnneeett-wwww-oooo-rrrr-kkkkkkk22222`
## [1] "WRITE"
## $`nnneeett-wwww-oooo-rrrr-kkkkkkk33333`
## [1] "READ"
# networkIds = names(networkPermissions)
## [1] "nnneeett-wwww-oooo-rrrr-kkkkkkk11111" "nnneeett-wwww-oooo-rrrr-kkkkkkk22222"
## [3] "nnneeett-wwww-oooo-rrrr-kkkkkkk33333" 
## get all networks for which the user has Admin permissions
# networkPermissions = ndex_user_list_permissions(ndexcon, userId, type='ADMIN')
## $`nnneeett-wwww-oooo-rrrr-kkkkkkk11111`
## [1] "ADMIN"
## get all networks for which the user has direct access
# networkPermissions = ndex_user_list_permissions(ndexcon, user$externalId, directonly=TRUE)
## $`nnneeett-wwww-oooo-rrrr-kkkkkkk11111`
## [1] "ADMIN"
NULL
}
