% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_simple_operations.r
\name{ndex_update_network}
\alias{ndex_update_network}
\title{Update an Entire Network as CX}
\usage{
ndex_update_network(ndexcon, rcx, networkId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{rcx}{\code{\link[RCX]{RCX-object}} object}

\item{networkId}{(optional); unique ID of the network}
}
\value{
UUID of the updated network
}
\description{
\strong{Note: In future `ndexr` uses the \link[RCX]{RCX-object} from the corresponding package to handle the networks!}
}
\details{
This method updates/replaces a existing network on the NDEx server with new content from the given RCX object.
The UUID can either be specified manually or it will be extracted from the RCX object (i.e. from rcx$ndexStatus$externalId).
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 1.3 and 2.0
}
\section{REST query}{

PUT (multipart/form-data): ndex_config$api$network$update$url
data: CXNetworkStream = data
}

\examples{
## Establish a server connections with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## Get the network data 
# rcx = ndex_get_network(ndexcon, networkId) 
## Do some changes to rcx..
## and update the network
# networkId = ndex_update_network(ndexcon, rcx, networkId)
# networkId = ndex_update_network(ndexcon, rcx) ## same as previous
NULL
}
