% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_simple_operations.r
\name{ndex_network_get_summary}
\alias{ndex_network_get_summary}
\title{Get NetworkSummary by Network UUID}
\usage{
ndex_network_get_summary(ndexcon, networkId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}
}
\value{
List of network metadata: ID, name, whether it is public, edge and node count; source and format of network
}
\description{
This function retrieves the summary of the network identified by the supplied network UUID string.
}
\note{
Compatible to NDEx server version 1.3 and 2.0
}
\section{REST query}{

GET: ndex_config$api$network$summary$get
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a network and get its UUID
networks = ndex_find_networks(ndexcon,"p53", "nci-pid")
networkId = networks[1,"externalId"]
## Get the network summary
summary = ndex_network_get_summary(ndexcon, networkId)
}
