% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_maintenance.R
\name{listToRCode}
\alias{listToRCode}
\title{Translates a nested list (as provided by a yaml file) into R code defining the lists}
\usage{
listToRCode(obj, indent = "    ", indentShift = "")
}
\arguments{
\item{obj}{list; Nested list to be translated. The allowed list elements are: list, character, numeric, logical}

\item{indent}{character (optional) (default: '    '[4 whitespaces]); Character(s) used for the indentation. Default: <tab>}

\item{indentShift}{character (optional) (default: ''); Shifts the block to the right by putting the characters before each line (mostly used in internal recursion)}
}
\value{
character; R code for generating the nested list
}
\description{
Translates a nested list (as provided by a yaml file) into R code defining the lists
}
\note{
only for package maintenance!
}
\examples{
test = list(bla='some text',blubb=list(a='more text', version='2.0'),justANumber=123456)
#$bla
#[1] "some text"
#$blubb
#$blubb$a
#[1] "more text"
#$blubb$version
#[1] "2.0"
#$justANumber
#[1] 123456
#
#listToRCode(test)
#[1] "list(\n\tbla=\"some text\",\n\tblubb=list(\n\t\ta=\"more text\",\n\t\tversion=\"2.0\"\n\t)\n)"
}
\keyword{internal}
