% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/ncdfFlowList-methods.R
\docType{class}
\name{ncdfFlowList-class}
\alias{ncdfFlowList-class}
\alias{ncdfFlowList}
\alias{show,ncdfFlowList-method}
\title{a class that stores multiple ncdfFlowSet objects}
\usage{
ncdfFlowList(x, samples = NULL)

\S4method{show}{ncdfFlowList}(object)
}
\arguments{
\item{x}{\code{list} of \code{ncdfFlowSet} objects}

\item{samples}{\code{integer} see \code{samples} slot of \code{ncdfFlowList} class.
or \code{character} that specifiy the order to samples.
                  If not given then reconstruct the index.}

\item{object}{\code{ncdfFlowList}}
}
\value{
\code{ncdfFlowList-class}
}
\description{
It is a list of ncdfFlowSet objects
}
\section{Objects from the Class}{

Objects can be created by coercing a list of ncdfFlowSet objects 
as("ncdfFlowList",nclist = .... #a list of ncdfFlowSet objects)
}

\section{Slots}{

 \describe{

\item{\code{data}:}{A list containing the \link{ncdfFlowSet} objects.}
\item{\code{samples}:}{A \code{integer} vector containing the index of the \link{ncdfFlowSet} object to which each sample belongs.
                       The name of the vector is the sample names that determine the order of samples exposed to the user, which can
                       be different from the physical storing order.}
}
}

\examples{
data(GvHD)
nc1 <- ncdfFlowSet(GvHD[1])
nc2 <- ncdfFlowSet(GvHD[2])
nc3 <- ncdfFlowSet(GvHD[3])
list1 <- list(nc1, nc2, nc3)
#coerce from list to ncdfFlowList
nclist <- ncdfFlowList(list1)
nclist
#coerce(collapse) from ncdfFlowList to a single flowFrame
collapsedData <- as(nclist, "flowFrame")
collapsedData
}
\seealso{
\code{\link{ncdfFlowSet}}
}
