% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFlowFrame.R
\name{[[,ncdfFlowSet,ANY-method}
\alias{[[,ncdfFlowSet,ANY-method}
\alias{[[,ncdfFlowList,numeric-method}
\alias{[[,ncdfFlowList,logical-method}
\alias{[[,ncdfFlowList,character-method}
\alias{[[,ncdfFlowList,character,missing-method}
\title{extract a \code{flowFrame} object from \code{ncdfFlowSet}}
\usage{
\S4method{[[}{ncdfFlowSet,ANY}(x, i, j, use.exprs = TRUE, ...)

\S4method{[[}{ncdfFlowList,numeric}(x, i, j, ...)

\S4method{[[}{ncdfFlowList,logical}(x, i, j, ...)

\S4method{[[}{ncdfFlowList,character}(x, i, j, ...)
}
\arguments{
\item{x}{a \code{ncdfFlowSet} or \code{ncdfFlowList}}

\item{i}{a \code{numeric} or \code{character} used as sample index}

\item{j}{a \code{numeric} or \code{character} used as channel index}

\item{use.exprs}{a \code{logical} scalar indicating whether to read the actual data from cdf}

\item{...}{other arguments. not used.}
}
\description{
Simliar to \code{\link[=[[,flowSet-method]{[[}}, and there are cerntain ways to 
reduce the disk IO and optimize the speed.
}
\examples{
data(GvHD)
nc <- ncdfFlowSet(GvHD[1:2])
samples <- sampleNames(nc)
sn <- samples[1]
#return the entire flowFrame
fr <- nc[[sn]]  

#access the flowFrame meta data without loading the raw event data from disk
nc[[sn, use.exprs = FALSE]]

#only read a subset of channels (more efficient than reading entire data set) 
nc[[sn, 1:2]]

}
