% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{ncGTWparam-class}
\alias{ncGTWparam-class}
\alias{ncGTWparam}
\title{Class "ncGTWparam"}
\description{
An S4 class for storing the needed paramters of ncGTW alignment.
}
\details{
This function initializes the needed paramters of ncGTW alignment
with defaults, so this function could be called without any input. The
alignment should be fine with all default parameters. If the computing time
is an issue, the user could consider increase \code{downSample} and/or
decrease \code{stpRat} for a faster speed. If the alignment result is not
good enough, one can consider increase \code{strNum} and/or \code{diaNum}
to integrate more neighboring information to increase the quality of
alignment, but the speed may drop.
}
\section{Slots}{

\describe{
\item{\code{downSample}}{A factor of downsampling. The larger, the faster speed
of alignment, but the accuracy may decrease. The default is 2.}

\item{\code{stpRat}}{A factor to control the maximum RT shift of a point in
alignment, and the maximum shift is determined by \code{stpRat} * "The RT
range of the feature". If \code{maxStp} is set, then \code{stpRat} would be
neglected. The default is 0.6.}

\item{\code{maxStp}}{A value determines the maximum RT shift of a point in ncGTW
alignment. If the user wants to decide the maximum shif by the RT range of
the feature, this argument should be NaN. The default is NaN.}

\item{\code{strNum}}{A value controls how many neighboring warping functions are
connected to each warping function in ncGTW graph. There are two samples
corresponding to a warping function, and at least one sample should be the
same in another warping function to be considered as a neighbor controlled
by \code{strNum}.}

\item{\code{diaNum}}{A value controls how many neighboring warping functions are
connected to each warping function in ncGTW graph. There are two samples
corresponding to a warping function, and the two samples could also be
different to another warping function to be considered as a neighbor
controlled by \code{diaNum}.}

\item{\code{nor}}{A value controls p-norm to compute the distance between the
points on the profiles, and the default is 1 (Manhattan norm).}
}}

