% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncGTWutility.R
\name{compCV}
\alias{compCV}
\title{Compare CV}
\usage{
compCV(XCMSresFilled, na.rm = FALSE)
}
\arguments{
\item{XCMSresFilled}{A \code{\link[xcms]{xcmsSet-class}} object.}

\item{na.rm}{Omit the samples in which the feature is not detected, and the
default is FALSE.}
}
\value{
A vector of the same length as the row number of the \code{group}
slot in \code{XCMSresFilled}, in which each element is the CV.
}
\description{
This function calculates the coefficient of variation of each feature.
}
\details{
This function calculates the coefficient of variation of each
feature across all the samples. If a sample is detected with more than one
peaks in the feature, the function will pick the one with the highest
intensity value.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin

cv <- compCV(xcmsLargeWin)
}
