% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{metrics}
\alias{metrics}
\alias{metrics,musica-method}
\alias{metrics,result_collection-method}
\alias{metrics,result_model-method}
\alias{metrics<-}
\alias{metrics<-,musica,SimpleList-method}
\alias{metrics<-,result_collection,SimpleList-method}
\alias{metrics<-,result_model,SimpleList-method}
\title{Retrieve metrics from a result_model, result_collection, or musica
object}
\usage{
metrics(x, ...)

\S4method{metrics}{musica}(x, result, modality, model_id)

\S4method{metrics}{result_collection}(x, modality, model_id)

\S4method{metrics}{result_model}(x)

metrics(x, ...) <- value

\S4method{metrics}{musica,SimpleList}(x, result, modality, model_id) <- value

\S4method{metrics}{result_collection,SimpleList}(x, modality, model_id) <- value

\S4method{metrics}{result_model,SimpleList}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs}

\item{result}{Name of result from result_list to assign the
metrics. Used when \code{result} is a \code{\linkS4class{musica}} object.}

\item{modality}{Modality to assign the metrics. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the metrics. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{value}{List of metrics}
}
\value{
The metrics for the model
}
\description{
Metrics for the model
}
\examples{
data(res)
metrics(res, "result", "SBS96", "res")
}
