% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stagewiseDD.R
\name{stagewise_DS_DD}
\alias{stagewise_DS_DD}
\title{Perform two-stage testing on DS and DD analysis results}
\usage{
stagewise_DS_DD(res_DS, res_DD, sce = NULL, verbose = FALSE)
}
\arguments{
\item{res_DS}{a list of DS testing results as returned 
by \code{\link{pbDS}} or \code{\link{mmDS}}.}

\item{res_DD}{a list of DD testing results as returned 
by \code{\link{pbDD}} (or \code{\link{pbDS}} with \code{method="DD"}).}

\item{sce}{(optional) \code{SingleCellExperiment} object containing the data 
that underlies testing, prior to summarization with \code{\link{aggregateData}}. 
Used for validation of inputs in order to prevent unexpected failure/results.}

\item{verbose}{logical. Should information on progress be reported?}
}
\value{
A list of \code{DFrame}s containing results for each contrast and cluster.
Each table contains DS and DD results for genes shared between analyses,
as well as results from stagewise testing analysis, namely:
\itemize{
\item{\code{p_adj}: FDR adjusted p-values for the
  screening hypothesis that a gene is neither DS nor DD
  (see \code{?stageR::getAdjustedPValues} for details)}
\item{\code{p_val.DS/D}: confirmation stage p-values for DS/D}}
}
\description{
Perform two-stage testing on DS and DD analysis results
}
\examples{
data(example_sce)

pbs_sum <- aggregateData(example_sce, assay="counts", fun="sum")
pbs_det <- aggregateData(example_sce, assay="counts", fun="num.detected")
  
res_DS <- pbDS(pbs_sum, min_cells=0, filter="none", verbose=FALSE)
res_DD <- pbDD(pbs_det, min_cells=0, filter="none", verbose=FALSE)

res <- stagewise_DS_DD(res_DS, res_DD)
head(res[[1]][[1]]) # results for 1st cluster

}
