% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbMDS.R
\name{pbMDS}
\alias{pbMDS}
\title{Pseudobulk-level MDS plot}
\usage{
pbMDS(x)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}} 
containing cluster-sample pseudobulks as returned by 
\code{\link{aggregateData}} with argument 
\code{by = c("cluster_id", "sample_id")}.}
}
\value{
a \code{ggplot} object.
}
\description{
Renders a multidimensional scaling (MDS) 
  where each point represents a cluster-sample instance; 
  with points colored by cluster ID and shaped by group ID.
}
\examples{
data(example_sce)
pb <- aggregateData(example_sce)
pbMDS(pb)

}
\author{
Helena L Crowell & Mark D Robinson
}
