% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbHW.R
\name{gBH}
\alias{gBH}
\title{gBH - Grouped Benjamini-Hochberg procedure}
\usage{
gBH(p, bins, pi0 = c("LSL", "TST"), alpha = 0.05)
}
\arguments{
\item{p}{A vector of p-values.}

\item{bins}{A factor of same length as `p`
indicating to which bin the p-value belongs.}

\item{pi0}{The pi0 estimation method, either LSL (default) or TST.}

\item{alpha}{The desired FDR control (ignored for the LSL method).}
}
\value{
A vector of same length as `p` with the adjusted p-values.
}
\description{
This computes adjusted p-values using a user-defined grouping of the 
hypotheses, following the method from Hu, Zhao and Zhou (2010).
}
\details{
This is partly inspired from code in the c212 package by Raymond Carragher,
which followed the implementation described in Hu, Zhao and Zhou (2010). The 
implementation was adapted to use vector operations to be (a lot) 
faster, and to produce adjusted p-values (rather than a rejection rule).

The method has two variants which differ in the way the rate of true null
hypotheses (pi0) in each group/bin is estimated. The Two-Stage (TST) method 
uses Benjamini & Hochberg's FDR method to estimate the proportion of 
rejections in each group, and bases the pi0 on this. The LSL method uses
the Least-Slope estimator proposed by Benjamini and Hochberg (2000). We 
recommend using the LSL method (default), which was more robust in our hands
and has the virtue of not being dependent on an input alpha.
}
\examples{
# generate data with fake p-values and bins that are somewhat informative:
d <- data.frame(
  p=c(abs(rnorm(500,sd=0.01)), runif(4500)),
  truth=rep(c(TRUE,FALSE), c(500,4500)),
  bins=c(sample(LETTERS[1:10], 500, c(0.55,rep(0.05,9)), replace=TRUE),
         sample(LETTERS[1:10], 4500, replace=TRUE)))
# compute grouped adjusted p-values:
d$padj_grouped <- gBH(d$p, d$bins)
table(truth=d$truth, grouped=d$padj_grouped<0.05)
# compare with the normal BH:
d$padj_normal <- p.adjust(d$p, method="fdr")
table(truth=d$truth, normal=d$padj_normal<0.05)

}
\references{
Hu, J. X. and Zhao, H. and Zhou, H. H. (2010). False Discovery Rate 
  Control With Groups. J Am Stat Assoc, 105(491):1215-1227.
Benjamini Y, Hochberg Y. (2000). On the Adaptive Control of the False 
  Discovery Rate in Multiple Testing With Independent Statistics. Journal of 
  Educational and Behavioral Statistics, 25(1):60–83.
}
\author{
Pierre-Luc Germain
}
