% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_find_spacers.R
\name{extend_for_pe}
\alias{extend_for_pe}
\title{Extend ranges for prime editing}
\usage{
extend_for_pe(
  gr,
  bsgenome,
  nrt = 16,
  spacer = strrep("N", 20),
  pam = "NGG",
  plot = FALSE
)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}

\item{nrt}{number: reverse transcription length}

\item{spacer}{string: spacer pattern in extended IUPAC alphabet}

\item{pam}{string: pam pattern in extended IUPAC alphabet}

\item{plot}{TRUE (default) or FALSE}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Extend target ranges to span in which to look for spacer-pam seqs
}
\details{
Extend target ranges to find nearby spacers for prime editing
}
\examples{
require(magrittr)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
gr <- char_to_granges(c( PRNP = 'chr20:4699600:+',             # snp
                         HBB  = 'chr11:5227002:-',             # snp
                         HEXA = 'chr15:72346580-72346583:-',   # del
                         CFTR = 'chr7:117559593-117559595:+'), # ins
                     bsgenome = bsgenome)
find_primespacers(gr, bsgenome)
(grext <- extend_for_pe(gr))
find_spacers(grext, bsgenome, complement = FALSE)
}
