% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{topNGenes}
\alias{topNGenes}
\title{topNGenes: Top N genes of a module}
\usage{
topNGenes(WGCNAobject, module, nGenes = NULL)
}
\arguments{
\item{WGCNAobject}{an object of class WGCNA}

\item{module}{the name of the module in WGCNAobject}

\item{nGenes}{an integer from 1 to module size; returns all genes if left NULL}
}
\value{
a character vector of the genes/probes in the module
}
\description{
Returns the top N number of genes of a module.
All genes returned if no number is specified.
Genes are in order of intramodular connectivity.
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
topNGenes(astrocyte_networks$EAE, "EAE_015", nGenes = 10)

}
