% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{moduleComparisonPlot}
\alias{moduleComparisonPlot}
\title{Module comparison plot}
\usage{
moduleComparisonPlot(overlapDf, dataset1, dataset2)
}
\arguments{
\item{overlapDf}{a data.frame resulting from a call to computeOverlapsFromWGCNA}

\item{dataset1}{an object of class WGCNA to compare with dataset2}

\item{dataset2}{an object of class WGCNA to compare with dataset1}
}
\value{
Returns a ggplot object (flowplot and heatmap) showing the module correspondence 
between two objects of class WGCNA
}
\description{
A plotting function that returns a heatmap and barplot for a module
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
overlapDf = computeOverlapsFromWGCNA(astrocyte_networks$EAE, astrocyte_networks$WT)
moduleComparisonPlot(overlapDf, astrocyte_networks$EAE, astrocyte_networks$WT)

}
\author{
Dario Tommasini
}
