% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runWGCNA.R
\name{constructNetworks}
\alias{constructNetworks}
\title{constructNetworks: Construct all the weighted gene correlation networks}
\usage{
constructNetworks(
  datExpr,
  sampleTable,
  conditions1,
  conditions2,
  write = FALSE,
  alphaLevel = 0.05,
  plot = FALSE,
  detectNumbers = TRUE,
  ...
)
}
\arguments{
\item{datExpr}{either a SummarizedExperiment object or data.frame with genes are rows and samples as columns}

\item{sampleTable}{data.frame with sample names in first column and sample traits in the second and third column. First column should be called "Sample"}

\item{conditions1}{first design conditions, ie healthy/disease}

\item{conditions2}{second design conditions, ie frontal lobe/temporal lobe}

\item{write}{write results out to files?}

\item{alphaLevel}{significance value passed to findBestTrait function, default is 0.05}

\item{plot}{plot modules? Default is false}

\item{detectNumbers}{passed to makeTraitTable2; if you have any numeric traits, make sure this is TRUE so that these get detected.}

\item{...}{Arguments to pass to blockwiseModules function}
}
\value{
A list of WGCNA objects, ie level one, two, and three networks.
}
\description{
A high level function that returns all networks
possible for a given experimental design
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
autism_se = eh_query[["EH8219"]]
set.seed(1)
autism_se = autism_se[sample(rownames(autism_se), 500),]
sampleTable = colData(autism_se)
conditions1 = unique(sampleTable[,2])
conditions2 = unique(sampleTable[,3])
autism_networks = constructNetworks(autism_se, sampleTable, conditions1[[1]], conditions2[[1]], 
  networkType = "signed", TOMType = "unsigned", 
  power = 10, minModuleSize = 100, maxBlockSize = 25000,
  reassignThreshold = 0, minKMEtoStay = 0, mergeCutHeight = 0,
  numericLabels = TRUE, pamRespectsDendro = FALSE, 
  deepSplit = 4, verbose = 3)
autism_networks[["combined"]]

}
\author{
Dario Tommasini
}
