% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{GetDatExpr}
\alias{GetDatExpr}
\title{Get expression data}
\usage{
GetDatExpr(object, genes = NULL)
}
\arguments{
\item{object}{An object of class WGCNA}

\item{genes}{a list of genes to subset to; default is NULL}
}
\value{
a data.frame
}
\description{
Returns the expression data frame a WGCNA object as a data.frame
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
datExpr = GetDatExpr(astrocyte_networks[[1]], 
  genes = topNGenes(astrocyte_networks$EAE, "EAE_015", 20))
coexpressionLineGraph(datExpr)	+ 
  geom_vline(xintercept = 20.5, linetype='dashed')

}
\author{
Dario Tommasini
}
