% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{pval_heatmap}
\alias{pval_heatmap}
\title{Function to visualize p-values from multiHiCcompare results}
\usage{
pval_heatmap(hicexp, alpha = NA, chr = 0)
}
\arguments{
\item{hicexp}{A hicexp object that has been
normalized and has had differences detected.}

\item{alpha}{The alpha level at which you will 
call a p-value significant. If this is set to
a numeric value then any p-values >= alpha will
be set to 1 for the visualization in the heatmap.
Defaults to NA for visualization of all p-values.}

\item{chr}{The numeric value for the chromosome that 
you want to plot. Set to 0 to plot all chromosomes
in the dataset.}
}
\value{
A heatmap
}
\description{
Function to visualize p-values from multiHiCcompare results
}
\details{
The goal of this function is to visualize
    where in the Hi-C matrix the differences are
    occuring between two experimental conditions.
    The function will produce a heatmap of the
    -log10(p-values) * sign(logFC) 
    to visualize where the
    significant differences between the datasets
    are occuring on the genome.
}
\examples{
data("hicexp_diff")
pval_heatmap(hicexp_diff, chr = 22)
}
