% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{hic_exactTest}
\alias{hic_exactTest}
\title{Perform exact test based difference detection on a Hi-C experiment}
\usage{
hic_exactTest(hicexp, parallel = FALSE, p.method = "fdr", max.pool = 0.7)
}
\arguments{
\item{hicexp}{A hicexp object.}

\item{parallel}{Logical, should parallel processing be used?}

\item{p.method}{Charact string to be input into p.adjust()
as the method for multiple testing correction. Defaults to "fdr".}

\item{max.pool}{The proportion of unit distances after
which all further distances will be pooled. Distances
before this value will be progressively pooled and
any distances after this value will be combined
into a single pool. Defaults to 0.7. Warning: do
not adjust this value from the default unless you
are getting errors related to the lfproc function
or due to sparsity in fastlo normalization. If these
errors occur it is due to either sparsity or low 
variance and max.pool will need to be lowered; 
typically to 0.5 or 0.6.}
}
\value{
A hicexp object with the comparison slot filled.
}
\description{
Perform exact test based difference detection on a Hi-C experiment
}
\details{
This function performs the edgeR exact test on a per distance
    basis for Hi-C data. It tests for differences between two groups
    when the groups are the only variable of interest. This is
    an application of the negative binomial exact test proposed
    by Robinson and Smyth (2008) for a difference in mean between
    the groups. These exact tests are applied to the Hi-C data
    on a distance group basis using "progressive pooling" of 
    distances.
}
\examples{
\dontrun{
data("hicexp_diff")
hicexp_diff <- hic_exactTest(hicexp_diff)}

}
