% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclic_loess.R
\name{cyclic_loess}
\alias{cyclic_loess}
\title{Cyclic Loess normalization for Hi-C data}
\usage{
cyclic_loess(
  hicexp,
  iterations = 3,
  span = NA,
  parallel = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{hicexp}{A hicexp object}

\item{iterations}{The number of iterations (cycles) 
of loess normalization to perform. Defaults to 3.}

\item{span}{The span for loess normalization. Defaults to
NA indicating that span will be automatically calculated
using generalized cross validation.}

\item{parallel}{Logical. Should parallel processing be used?}

\item{verbose}{Logical. Should messages about loess normalization
be printed to the screen.}
}
\value{
A hicexp object that has been normalized.
}
\description{
Cyclic Loess normalization for Hi-C data
}
\details{
This function performs cyclic loess normalization
   on a Hi-C experiment. multiHiCcompare's cyclic loess procedure
   is a modified version of Ballman's (2004) cyclic loess and
   the joint loess normalization used in the original HiCcompare.
   For each unique pair of samples in the hicexp object an MD plot
   is generated. A loess curve is fit to the MD plot and then the 
   fitted values are used to adjust the data. This is performed on
   all unique pairs and then repeated until convergence.
}
\examples{
#' data("hicexp2")
hicexp2 <- cyclic_loess(hicexp2, span = 0.7)
}
