% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{MD_hicexp}
\alias{MD_hicexp}
\title{Make MD plots for all combinations of a condition}
\usage{
MD_hicexp(hicexp, prow = 3, pcol = 3, plot.chr = NA, plot.loess = FALSE)
}
\arguments{
\item{hicexp}{A hicexp object.}

\item{prow}{The number of rows to use for the 
grid of MD plots. Defaults to 3.}

\item{pcol}{The number of columns to use for
the grid of MD plots. Defaults to 3.}

\item{plot.chr}{A specific chromosome or 
set of chromosome which you want to plot.
This should be a numeric value, i.e. to
plot chromosome 1 set plot.chr = 1, to
plot chromosomes 1 and 5 set plot.chr 
= c(1, 5). Defaults to NA indicating that
all chromosomes present in the hicexp
will be plotted.}

\item{plot.loess}{Logical, should a loess curve
be plotted over the MD plots. Note setting
this to TRUE will increase the computational
time for plotting.}
}
\value{
A set of MD plots.
}
\description{
Make MD plots for all combinations of a condition
}
\examples{
data("hicexp2")
MD_hicexp(hicexp2)
}
