% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{combinePvalues}
\alias{combinePvalues}
\title{Calculate a combined p-value for multiple omics layer.}
\usage{
combinePvalues(df, method = "stouffer", col_pattern = "pval", weights = NULL)
}
\arguments{
\item{df}{Data frame where rows represent a certain pathway or gene set and
columns represent p-values derived from independent tests, e.g., different
omics layer.}

\item{method}{String that specifies the method to combine multiple p-values.
Default: "stouffer" Options: "stouffer", "fisher", "edgington"}

\item{col_pattern}{String of the pattern that specifies the columns to be
combined. Default: "pval", Options: "pval", "padj" (legacy)}

\item{weights}{List of weights that will be used in a weighted Stouffer
method.}
}
\value{
Vector of length \code{nrow(df)} with combined p-values.
}
\description{
This function applies the Stouffer method, the Edgington method or the
Fisher\'s combined probability test to combine p-values of independent tests
that are based on the same null hypothesis. The Stouffer method can also be
applied in a weighted fashion.
}
\examples{
df <- cbind(runif(5), runif(5), runif(5))
colnames(df) <- c("trans.pval", "prot.pval", "meta.pval")

# run the unweighted summation of z values
combinePvalues(df)

# run the weighted variant
combinePvalues(df, weights = c(10, 5, 1))

# run the Fisher's combined probability test
combinePvalues(df, method = "fisher")

# run the Edgington's method
combinePvalues(df, method = "edgington")
}
