% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topFeatures.R
\name{topFeatures}
\alias{topFeatures}
\title{Toplist of DE proteins, peptides or features}
\usage{
topFeatures(models, contrast, adjust.method = "BH", sort = TRUE, alpha = 1)
}
\arguments{
\item{models}{A list with elements of the class \code{StatModel} that are
estimated using the \code{\link{msqrob}} function}

\item{contrast}{\code{numeric} (matrix)vector specifying one contrast of
the linear model coefficients to be tested equal to zero.
The (row)names of the vector should be equal to the names of
parameters of the model.}

\item{adjust.method}{\code{character} specifying the method to adjust
the p-values for multiple testing.
Options, in increasing conservatism, include ‘"none"’,
‘"BH"’, ‘"BY"’ and ‘"holm"’.  See ‘p.adjust’ for the complete
list of options. Default is "BH" the Benjamini-Hochberg method
to controle the False Discovery Rate (FDR).}

\item{sort}{\code{boolean(1)} to indicate if the features have to be sorted according
to statistical significance.}

\item{alpha}{\code{numeric} specifying the cutoff value for adjusted p-values.
Only features with lower p-values are listed.}
}
\value{
A dataframe with log2 fold changes (logFC), standard errors (se),
degrees of freedom of the test (df), t-test statistic (t),
p-values (pval) and adjusted pvalues (adjPval) using the specified
adjust.method in the p.adjust function of the stats package.
}
\description{
Summary table of the differentially expressed Features
}
\examples{
data(pe)

# Aggregate peptide intensities in protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")

# Fit msqrob model
pe <- msqrob(pe, i = "protein", formula = ~condition)

# Define contrast
getCoef(rowData(pe[["protein"]])$msqrobModels[[1]])

# Assess log2 fold change between condition c and condition b:
L <- makeContrast("conditionc - conditionb=0", c("conditionb", "conditionc"))
topDeProteins <- topFeatures(rowData(pe[["protein"]])$msqrobModels, L)
}
\author{
Lieven Clement
}
