% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_pd.R
\name{prepare_pd}
\alias{prepare_pd}
\title{prepare_pd
Prepare a label free quantification file exported from Proteome Discoverer
for subsequent mspms analysis.}
\usage{
prepare_pd(
  peptide_groups_filepath,
  colData_filepath,
  peptide_library = mspms::peptide_library,
  n_residues = 4
)
}
\arguments{
\item{peptide_groups_filepath}{filepath to PeptideGroups.txt file exported
from proteome discoverer.}

\item{colData_filepath}{file path to .csv file containing colData.
Must have columns named "quantCols","group","condition",and "time".}

\item{peptide_library}{peptide library used with experiment. Contains
columns "library_id", "library_match_sequence", and "library_real_sequence".}

\item{n_residues}{the number of amino acid residues before and after the
cleavage site to generate a cleavage seq for.}
}
\value{
a QFeatures object containing a summarizedExperiment named "peptides"
}
\description{
prepare_pd
Prepare a label free quantification file exported from Proteome Discoverer
for subsequent mspms analysis.
}
\examples{
peptide_groups_filepath <- system.file(
  "extdata/proteome_discoverer_PeptideGroups.txt",
  package = "mspms"
)
colData_filepath <- system.file("extdata/colData.csv", package = "mspms")
}
