% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_helper_functions.R
\name{cleavage}
\alias{cleavage}
\title{Generalized cleavage function with dynamic column names}
\usage{
cleavage(
  peptide_sequence,
  library_match_sequence,
  library_real_sequence,
  n_residues = 4,
  terminus = c("nterm", "cterm")
)
}
\arguments{
\item{peptide_sequence}{Peptide sequence, single-letter code. "_" denotes cleavage site.}

\item{library_match_sequence}{Sequence matched by proteomics software (may differ from real sequence).}

\item{library_real_sequence}{True peptide sequence.}

\item{n_residues}{Number of residues to include on each side of the cleavage site.}

\item{terminus}{"nterm" or "cterm", specifying which terminus to analyze.}
}
\value{
tibble with peptide, cleavage sequence, and cleavage position. Column names are
dynamically named based on the terminus.
}
\description{
Finds cleavage sequences for either N-terminal or C-terminal cleavages
relative to a peptide library sequence.
}
\keyword{internal}
