% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawCounts.R
\name{rawCounts}
\alias{rawCounts}
\title{rawCounts}
\usage{
rawCounts(bamFilepath, threads = 1)
}
\arguments{
\item{bamFilepath}{The path to the location of the bam file(s).}

\item{threads}{The total number of usable threads to be used. Default is 1.}
}
\value{
Produces a RangedSummarizedExperiment. Columns are samples and the rows are cut sites. The cut site IDs are in the format chr:position-position:strand.
}
\description{
Imports the raw read counts from sorted and indexed bam file(s)
}
\examples{
my_path <- system.file("extdata", package = "msgbsR")
my_data <- rawCounts(bamFilepath = my_path)
}
\author{
Benjamin Mayne, Sam Buckberry
}

