% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityX-constructor.R
\name{purityX}
\alias{purityX}
\title{Assessing anticipated purity of XCMS features from an LC-MS run}
\usage{
purityX(
  xset,
  purityType = "purityFWHMmedian",
  offsets = c(0.5, 0.5),
  fileignore = NULL,
  cores = 1,
  xgroups = NULL,
  iwNorm = FALSE,
  iwNormFun = NULL,
  ilim = 0.05,
  plotP = FALSE,
  mzRback = "pwiz",
  isotopes = FALSE,
  im = NULL,
  singleFile = 0,
  rtrawColumns = FALSE,
  saveEIC = FALSE,
  sqlitePth = NULL
)
}
\arguments{
\item{xset}{object; xcms object}

\item{purityType}{character; Area and average used for the purity predictions. Options are
"purityFWHMmedian", "purityFWmedian", "purityFWHMmean", "purityFWmean"}

\item{offsets}{vector; vector of the isolation window upper and lower offsets}

\item{fileignore}{vector; vector of files to ignore for the prediction calculation}

\item{cores}{numeric; number of cores to use}

\item{xgroups}{vector; vector of xcms groups to perform prediction on}

\item{iwNorm}{boolean; if TRUE then the intensity of the isolation window will be normalised based on the iwNormFun function}

\item{iwNormFun}{function; A function to normalise the isolation window intensity. The default function is very generalised and just accounts for edge effects}

\item{ilim}{numeric; All peaks less than this percentage of the target peak will be removed from the purity calculation, default is 5\% (0.05)}

\item{plotP}{boolean; TRUE if plot of the EIC of feature and associated contamination is the be save to the working directory}

\item{mzRback}{character; backend to use for mzR parsing}

\item{isotopes}{boolean; TRUE if isotopes are to be removed}

\item{im}{matrix; Isotope matrix, default removes C13 isotopes (single, double and triple bonds)}

\item{singleFile}{numeric; If just a single file for purity is to be calculated (rather than the grouped XCMS peaks). Uses the index of the files in xcmsSet object. If zero this is ignored.}

\item{rtrawColumns}{boolean; TRUE if the rt_raw values are included as additional columns in the @peaks slot (only required if using the obiwarp)}

\item{saveEIC}{boolean; If True extracted ion chromatograms will be saved to SQLite database}

\item{sqlitePth}{character; If saveEIC True, then a path to sqlite database can be used. If NULL then a database will be created in the working directory called eics}
}
\value{
a purityX object containing a dataframe of predicted purity scores
}
\description{
Constructor for the purityX class.

Given an XCMS object get the anticipated precursor purity of the grouped peaks
}
\examples{

msPths <- list.files(system.file("extdata", "lcms", "mzML", package="msPurityData"), full.names = TRUE, pattern = "LCMS_")
xset <- readRDS(system.file("extdata", "tests", "xcms", "ms_only_xset_OLD.rds", package="msPurity"))
xset@filepaths[1] <- msPths[basename(msPths)=="LCMS_1.mzML"]
xset@filepaths[2] <- msPths[basename(msPths)=="LCMS_2.mzML"]
px <- purityX(xset, singleFile = 1)

}
